//bench screws
//m.miller 04.26.23

// -----------------------------------------------------------------------------------------
//                      S C R E W S 
//------------------------------------------------------------------------------------------
#include "screws/screws.inc"  
#declare M_metal = material {M_steel_aged scale <.5,.5,.5>};

#declare screw_A = 
union{
    object { make_pan_head_flat(4,3) material{M_metal} }
    object { make_bolt(2,10,1)       material{M_metal} }
    }
    
    
#declare screw_B = 
union{
    object { make_pan_head_phillips(4,3) material{M_metal} }
    object { make_bolt(2,12,1)           material{M_metal} }
    }  

#declare screw_B_long = 
union{
    object { make_pan_head_phillips(4,3) material{M_metal} }
    object { make_bolt(2,30,1)           material{M_metal} }
    }  
    
    
#declare screw_C = 
union{    
    object { make_flat_head_phillips(2,1.5) material{M_metal} }
    object { make_bolt(2,30,1)              material{M_metal} }
    }
      
#declare bolt_A = 
union{      
    object { make_bolt_head(4,1.15) material{M_metal} }
    object { make_bolt(2,30,1)     material{M_metal} } 
    }
    

#declare bolt_B = 
union{      
    object { make_bolt_head(7,3) material{M_metal} }
    object { make_bolt(4,30,1)   material{M_metal} } 
    }
 

#declare bolt_C = 
union{      
    object { make_bolt_head(4,6) material{M_metal} }
    object { make_bolt(2,20,0)   material{M_metal} } 
    }
    
    
#declare nut = object { make_nut(4,1) material{M_metal} }


#declare washer_A = 
union{      
    object { make_washer(4,1.5,.5) material{M_metal} }
    }

 
 


#declare pointDataCount = 17 ;
#declare screwPos = array[pointDataCount] ;


#declare screwPos[0] = <158.342, 302.000, -155.206>  ;
#declare screwPos[1] = <150.697, 302.000, -176.240>  ;
#declare screwPos[2] = <149.816, 302.000, -149.053>  ;
#declare screwPos[3] = <40.138, 300.000, -285.189>  ;
#declare screwPos[4] = <38.531, 302.000, -291.999>  ;
#declare screwPos[5] = <20.808, 302.000, -208.310>  ;
#declare screwPos[6] = <21.906, 302.000, -192.275>  ;
#declare screwPos[7] = <28.686, 302.000, -188.885>  ;   

#declare screwPos[8] = <-144.315, 303.500, -210.056>  ;
#declare screwPos[9] = <-135.854, 303.000, -225.073>  ;
#declare screwPos[10] = <-163.757, 303.000, -210.509>  ;



#declare screwPos[11] = <4.507, 300.000, -31.482>  ;
#declare screwPos[12] = <-8.144, 300.000, -36.226>  ;
#declare screwPos[13] = <-65.838, 300.000, -31.292>  ;
#declare screwPos[14] = <-55.970, 300.000, -33.190>  ;
#declare screwPos[15] = <-42.685, 300.000, -31.292>  ;
#declare screwPos[16] = <-198.130, 300.000, -186.737>  ;  

 
 
#declare bench_screws = 
union {
    //screw and washer behind soldering gun
    object { screw_B scale <1,1,1> rotate<180,0,0>      translate screwPos[0] }  
    object { screw_B scale <1,1,1> rotate<78,-10,0>     translate screwPos[1] } 
    object { screw_B scale <1,1,1> rotate<78,90,0>      translate screwPos[2] } 
    union {
        object { washer_A scale <1,1,1> rotate<0,0,0>   translate  <149.816, 300.000, -139.053> } 
        object { washer_A scale <1,1,1> rotate<0,0,-4>  translate  <155.816, 300.25, -139.053> }
        translate <7,0,10>
    } 
    
    //screw and washer edge of bench and lid
    object { washer_A scale <1,1,1> rotate <0,0,0>          translate screwPos[3] } 
    object { screw_B scale <1,1,1>  rotate <78,80,0>        translate screwPos[4] } 
    
   
   //screws beside box
    union {
        object { screw_C scale <1,1,1> rotate<86,70,0>      translate screwPos[5] }
        object { screw_C scale <1,1,1> rotate<86,-60,0>     translate screwPos[6] }
        object { screw_C scale <1,1,1> rotate<86,-110,0>    translate screwPos[7] } 
        translate <-30,0,-10>
    }

    //bolts beside head shell
    union {
        object { bolt_B scale <1,1,1> rotate<180,0,0>       translate screwPos[8] }
        object { bolt_B scale <1,1,1> rotate<87,60,0>       translate screwPos[9] }
        object { bolt_B scale <1,1,1> rotate<87,-100,0>       translate screwPos[10] } 
        translate <-40,0,-60>
    }  
    
    //screws in shelf
    object { screw_B_long scale <1.5,1.5,1.5> rotate<-90,0,0>      translate <95,472,-80> }
    object { screw_B_long scale <1.5,1.5,1.5> rotate<-90,0,0>      translate <115,472,-75> } 
    
}



//#declare zoom_to = screwPos[9] ;